##/**
##  ******************************************************************************
##  * @file    Linux.mk
##  * @project CAN-ENET Software Support Package
##  *
##  * @version V2.0.0
##  * @date    April 2021
##  * @author  Oleksandr Bogush
##  *
##  * @copyright
##  * (c) Axiomatic Technologies Corp. All rights reserved.
##  *
##  * @brief
##  * This is a make file for building all Software Support Package examples in Linux.
##  *
##  * @usage <b>make -f Linux.mk </b><br>
##  *        The makefile should be started from the <i>./Examples</i> directory where
##  *        the file is located. Upon successful completion, all compiled examples and
##  *        object files will be located in the <i>./Bin</i> folder.
##  *
##  ******************************************************************************
##  * @attention
##  *
##  * <h2><center>&copy; COPYRIGHT(c) 2021 Axiomatic Technologies Corporation</center></h2>
##  *
##  * Redistribution and use in source and binary forms, with or without modification,
##  * are permitted provided that the following conditions are met:
##  *   1. Redistributions of source code must retain the above copyright notice,
##  *      this list of conditions and the following disclaimer.
##  *   2. Redistributions in binary form must reproduce the above copyright notice,
##  *      this list of conditions and the following disclaimer in the documentation
##  *      and/or other materials provided with the distribution.
##  *   3. Neither the name of Axiomatic Technologies Corporation nor the names of its contributors
##  *      may be used to endorse or promote products derived from this software
##  *      without specific prior written permission.
##  *
##  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
##  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
##  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
##  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
##  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
##  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
##  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
##  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
##  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##  *
##  ******************************************************************************
##  */
##/// @cond

SSP_CODE_DIR=../Src/
SSP_INCLUDE_DIR=../Inc/
BIN_DIR=./Bin/

CC=gcc
CFLAGS=

vpath %.c $(SSP_CODE_DIR)
vpath %.h $(SSP_INCLUDE_DIR)
vpath %.o $(BIN_DIR)


all: $(BIN_DIR) $(BIN_DIR)CANReceive.exe $(BIN_DIR)CANSend.exe $(BIN_DIR)Discovery.exe $(BIN_DIR)Heartbeat.exe $(BIN_DIR)StatusRequest.exe
	@echo All done!

$(BIN_DIR) :
	mkdir -p $(BIN_DIR)

$(BIN_DIR)CANReceive.exe : CANReceive.c $(BIN_DIR)PMessage.o $(BIN_DIR)CommProtocol.o
	$(CC) $(CFLAGS) -o $@ $^

$(BIN_DIR)CANSend.exe : CANSend.c $(BIN_DIR)PMessage.o $(BIN_DIR)CommProtocol.o
	$(CC) $(CFLAGS) -o $@ $^

$(BIN_DIR)Discovery.exe : Discovery.c $(BIN_DIR)PMessage.o $(BIN_DIR)DiscProtocol.o
	$(CC) $(CFLAGS) -o $@ $^

$(BIN_DIR)Heartbeat.exe : Heartbeat.c $(BIN_DIR)PMessage.o $(BIN_DIR)CommProtocol.o $(BIN_DIR)HealthData.o
	$(CC) $(CFLAGS) -o $@ $^

$(BIN_DIR)StatusRequest.exe : StatusRequest.c $(BIN_DIR)PMessage.o $(BIN_DIR)CommProtocol.o $(BIN_DIR)HealthData.o
	$(CC) $(CFLAGS) -o $@ $^

$(BIN_DIR)HealthData.o : HealthData.c HealthData.h CommonTypes.h
	$(CC) $(CFLAGS) -c -o $@ $<

$(BIN_DIR)DiscProtocol.o : DiscProtocol.c DiscProtocol.h PMessage.h CommonTypes.h
	$(CC) $(CFLAGS) -c -o $@ $<

$(BIN_DIR)CommProtocol.o : CommProtocol.c CommProtocol.h PMessage.h CommonTypes.h
	$(CC) $(CFLAGS) -c -o $@ $<

$(BIN_DIR)PMessage.o : PMessage.c PMessage.h CommonTypes.h
	$(CC) $(CFLAGS) -c -o $@ $<

##/// @endcond
