##/**
##  ******************************************************************************
##  * @file    Windows.mk
##  * @project CAN-ENET Software Support Package
##  *
##  * @version V2.0.0
##  * @date    October 2021
##  * @author  Oleksandr Bogush
##  *
##  * @copyright
##  * (c) Axiomatic Technologies Corp. All rights reserved.
##  *
##  * @brief
##  * This is a make file for building all Software Support Package examples in Microsoft Windows.
##  *
##  * @usage <b>nmake /F Windows.mk </b><br>
##  *        This make file is prepared for the _Microsoft Program Maintenance Utility_
##  *        <b>(nmake.exe)</b>. This utility together with the C compiler and linker is
##  *        included in the _Microsoft Visual Studio_ integrated development environment (IDE). The
##  *        _Visual Studio Community Edition_ can be downloaded for free from the
##  *        Microsoft website at: https://www.visualstudio.com/downloads/
##  *        The <b>nmake</b> utility should be started from the <i>Developer Command Prompt
##  *        for the Visual Studio</i> with the home directory in the <i>./Examples</i>
##  *        folder where the Windows.mk script is located.<br>
##  *        The _Developer Command Prompt for the Visual Studio_ sets all necessary
##  *        environmental variables for compiling and building the
##  *        example applications. Upon completion, the compiled examples and object
##  *        files will be located in the <i>./Bin</i> folder.<br>
##  *        Please note that the _Developer Command Prompt_ is installed with full
##  *        or community editions of _Visual Studio_. It is not installed with the
##  *        _Express_ versions of _Visual Studio_. The _Developer Command Prompt_
##  *        can be found in the Windows _Start_ menu in the _Visual Studio_ folder.
##  *
##  ******************************************************************************
##  * @attention
##  *
##  * <h2><center>&copy; COPYRIGHT(c) 2021 Axiomatic Technologies Corporation</center></h2>
##  *
##  * Redistribution and use in source and binary forms, with or without modification,
##  * are permitted provided that the following conditions are met:
##  *   1. Redistributions of source code must retain the above copyright notice,
##  *      this list of conditions and the following disclaimer.
##  *   2. Redistributions in binary form must reproduce the above copyright notice,
##  *      this list of conditions and the following disclaimer in the documentation
##  *      and/or other materials provided with the distribution.
##  *   3. Neither the name of Axiomatic Technologies Corporation nor the names of its contributors
##  *      may be used to endorse or promote products derived from this software
##  *      without specific prior written permission.
##  *
##  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
##  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
##  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
##  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
##  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
##  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
##  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
##  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
##  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##  *
##  ******************************************************************************
##  */
##/// @cond

SSP_CODE_DIR=..\Src^\
SSP_INCLUDE_DIR=..\Inc^\
BIN_DIR=.\Bin^\

CC=cl
CFLAGS=

all: $(BIN_DIR) $(BIN_DIR)CANReceive.exe $(BIN_DIR)CANSend.exe $(BIN_DIR)Discovery.exe $(BIN_DIR)Heartbeat.exe $(BIN_DIR)StatusRequest.exe
     @echo All done!

$(BIN_DIR) :
        -@IF NOT EXIST $(BIN_DIR) mkdir $(BIN_DIR)

$(BIN_DIR)CANReceive.exe : $(@B).c $(BIN_DIR)PMessage.obj $(BIN_DIR)CommProtocol.obj
        @$(CC) $(CFLAGS) /Fe$@ /Fo$@.obj $**

$(BIN_DIR)CANSend.exe : $(@B).c $(BIN_DIR)PMessage.obj $(BIN_DIR)CommProtocol.obj
        @$(CC) $(CFLAGS) /Fe$@ /Fo$@.obj $**

$(BIN_DIR)Discovery.exe : $(@B).c $(BIN_DIR)PMessage.obj $(BIN_DIR)DiscProtocol.obj
        @$(CC) $(CFLAGS) /Fe$@ /Fo$@.obj $**

$(BIN_DIR)Heartbeat.exe : $(@B).c $(BIN_DIR)PMessage.obj $(BIN_DIR)CommProtocol.obj $(BIN_DIR)HealthData.obj
        @$(CC) $(CFLAGS) /Fe$@ /Fo$@.obj $**

$(BIN_DIR)StatusRequest.exe : $(@B).c $(BIN_DIR)PMessage.obj $(BIN_DIR)CommProtocol.obj $(BIN_DIR)HealthData.obj
        @$(CC) $(CFLAGS) /Fe$@ /Fo$@.obj $**

$(BIN_DIR)CommProtocol.obj :  $(SSP_CODE_DIR)$(@B).c $(SSP_INCLUDE_DIR)CommProtocol.h $(SSP_INCLUDE_DIR)PMessage.h  $(SSP_INCLUDE_DIR)CommonTypes.h
        @$(CC) $(CFLAGS) /c /Fo$@ $(SSP_CODE_DIR)$(@B).c

$(BIN_DIR)DiscProtocol.obj :  $(SSP_CODE_DIR)$(@B).c $(SSP_INCLUDE_DIR)DiscProtocol.h $(SSP_INCLUDE_DIR)PMessage.h  $(SSP_INCLUDE_DIR)CommonTypes.h
        @$(CC) $(CFLAGS) /c /Fo$@ $(SSP_CODE_DIR)$(@B).c

$(BIN_DIR)HealthData.obj :  $(SSP_CODE_DIR)$(@B).c $(SSP_INCLUDE_DIR)HealthData.h  $(SSP_INCLUDE_DIR)CommonTypes.h
        @$(CC) $(CFLAGS) /c /Fo$@ $(SSP_CODE_DIR)$(@B).c

$(BIN_DIR)PMessage.obj :    $(SSP_CODE_DIR)$(@B).c   $(SSP_INCLUDE_DIR)PMessage.h  $(SSP_INCLUDE_DIR)CommonTypes.h
        @$(CC) $(CFLAGS) /c /Fo$@ $(SSP_CODE_DIR)$(@B).c

##/// @endcond
