/**
  ******************************************************************************
  * @file    CommonTypes.h
  * @project CAN-ENET Software Support Package
  *
  * @version V4.0.1
  * @date    December 2025
  * @author  Oleksandr Bogush
  *
  * @copyright
  * (c) Axiomatic Technologies Corp. All rights reserved.
  *
  * @brief
  * Basic data types and common macros
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2025 Axiomatic Technologies Corporation</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of Axiomatic Technologies Corporation nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef CommonTypes_H
#define CommonTypes_H

#ifdef __cplusplus
extern "C" {
#endif
/* Includes ------------------------------------------------------------------*/
#include <stdint.h>

/** @addtogroup CAN_ENET_SSP
  * @{
  */

/** @defgroup CommonTypes Common Types
  * Common Basic Types and Macros 
  * @{
  */

/* Exported constants --------------------------------------------------------*/
/** @defgroup CommonTypes_Exported_Constants Exported Constants
  * @{
  */

/** @defgroup CommonTypes_SSPBoolean_Constants SSP Boolean constants
  * @{
  */
#define CT_TRUE  1 /**< true */
#define CT_FALSE 0 /**< false */
/**
  * @}
  */
/**
  * @}
  */
/* Exported types ------------------------------------------------------------*/
/** @defgroup CommonTypes_Exported_Types Exported Types
  * @{
  */
/** @defgroup CommonTypes_SSPBasicTypes SSP basic types
  * @{
  */
typedef uint8_t     BYTE_t; /**< 1-byte unsigned integer */
typedef uint16_t    WORD_t; /**< 2-byte unsigned integer */
typedef uint32_t    DWORD_t; /**< 4-byte unsigned integer */
typedef int         BOOL_t; /**< boolean */
/**
  * @}
  */
/**
  * @}
  */
/* Exported macros -----------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
#ifdef __cplusplus
}
#endif

#endif /* CommonTypes_H */
/**
  * @}
  */
/**
  * @}
  */
